/*      Renegade Scripts.dll
        Example Plugin Code
        Copyright 2007 Whitedragon(MDB), Jonathan Wilson
 
        This file is part of the Renegade scripts.dll
        The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
        the terms of the GNU General Public License as published by the Free
        Software Foundation; either version 2, or (at your option) any later
        version. See the file COPYING for more details.
        In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
        Only the source code to the module(s) containing the licenced code has to be released.
*/
 
/*  This is designed to serve as both an example on how to make a plugin and to give users the basic framework of a plugin.
    The plugin is simple: it creates an object creation hook and attaches the script "Plugin_Example_Script" to all objects.
        The script prints out a message whenever an object is created or destroyed.
        There are also examples of the new format for bhs.dll hooks.
*/
 
#include "scripts.h"
#include <stdarg.h>
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include "engine.h"
#include "gmmain.h"
#include "sounds.h"
 
SimpleDynVecClass<Sound *> Sounds;
 
 
void Plugin_Load() {
printf("Plugin Sounds successfully loaded\n");
INIClass *ini = Get_INI("sounds.ini");
	if(!ini)
	{
		Console_Output("Plugin Sounds Error: Sounds.ini not found in Data folder.\n");
	}
	else
	{
		char number[8];
		char buffer[256];
		for(int i = 1; i < 256; i++)
		{
			sprintf(number, "%.2d", i);
			ini->Get_String("Sounds", number, "", buffer, 256);
			
        if(*number != 0)
        {
              Sound *s = new Sound;
              if(sscanf(buffer, "%s %s", s->trigger, s->sound) == 2)
              {
                  Sounds.Add(s);
                  continue;
              }
              delete s;
        }
        break;
    }
    Release_INI(ini);
	}
} 

void Plugin_Unload() {
	printf("Unloaded Sounds Plugin.\n");
}
 
extern "C" {
 
DLLEXPORT void SSGM_Chat_Hook(int ID, int Type, const wchar_t *Msg) {
if(Type != 0) return;

char Msg2[256];
sprintf(Msg2, "%S", Msg);


char trig[256];
if(sscanf(Msg2, "%s %*[]", trig) == 1)
{
   for(int i = 0; i < Sounds.Length(); i++)
   {
       if(stricmp(Sounds[i]->trigger, trig) == 0)
       {
            char buffer[256];
            sprintf(buffer, "snda %s", Sounds[i]->sound);
            Console_Input(buffer);
       }
   }
}
}
}




class CPChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "pamsg %d [SSGM]: Download link for Core Patch 2: http://download.renguard.com/cp2/patcher.zip", ID);
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "pamsg %d [SSGM]: Download link for Core Patch 2: http://download.renguard.com/cp2/patchall.zip", ID);
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<CPChatCommand> CPChatCommandReg("!cp",CHATTYPE_ALL,0,GAMEMODE_ALL);

class CP2ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "pamsg %d [SSGM]: Download link for Core Patch 2: http://download.renguard.com/cp2/patcher.zip", ID);
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "pamsg %d [SSGM]: Download link for Core Patch 2: http://download.renguard.com/cp2/patchall.zip", ID);
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<CP2ChatCommand> CP2ChatCommandReg("!cp2",CHATTYPE_ALL,0,GAMEMODE_ALL);

class SoundsChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "ppage %d [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.", ID);
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "ppage %d [SSGM]: You can display all sounds with commands: !sound1; !sound2; !sound3; !sound4; !sound5; !sound6; !sound7 and !sound8.", ID);
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<SoundsChatCommand> SoundsChatCommandReg("!sounds",CHATTYPE_ALL,0,GAMEMODE_ALL);

class SoundChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "ppage %d [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.", ID);
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "ppage %d [SSGM]: You can display all sounds with commands: !sound1; !sound2; !sound3; !sound4; !sound5; !sound6; !sound7 and !sound8.", ID);
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<SoundChatCommand> SoundChatCommandReg("!sound",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sound1ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: chicky, skill, hehe, hh, tt, tuff, yes_sir, yeah, fall, got_it, grunt, good, dead, oops, creature, lol, roar, target, incinerate, fire, smell, ^^, toast, pain, present");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sound1ChatCommand> Sound1ChatCommandReg("!sound1",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sound2ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: burn, stupid, mechman, bell, inc, cow, creak, sak, monster, run2, what, clear, hurry, kill_him, jerks, gameover, gg, helidown, hmm, hey, heh, go, fight, cover_me");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sound2ChatCommand> Sound2ChatCommandReg("!sound2",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sound3ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: negattive, sorry, die, affirmative, bye, cya, aha, traffic, terrorist, shutup, stfu, destroy, no, whoops, ns, fun, unstable, guys, where, meee, target, attack, bla, junior");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sound3ChatCommand> Sound3ChatCommandReg("!sound3",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sound4ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: candy, boink, boink2, door, rain, destruction, yes, rav, father, tv, help, dont_shoot_me, hello, hi, hi2, haha, muhaha, hihi, move, medic, elephants, ow, aw, not_now");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sound4ChatCommand> Sound4ChatCommandReg("!sound4",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sound5ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: situation_under_control, time_for_action, support, gotcha, gotya, coffee, ask, hunt, boo, pray, amateur, eye, lucky, finally, mobius, system_backup, dubi, shatter, hit, bravo");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sound5ChatCommand> Sound5ChatCommandReg("!sound5",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sound6ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: bear, rooster, battle, dogs, petrova, pet, job_hazard, out_of_the_way, who_is_there, call_a_doctor, man_down, dance, headache, munchies, dont_shoot, quiet, heads_up");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sound6ChatCommand> Sound6ChatCommandReg("!sound6",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sound7ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: watch_out, help2, squirrel, run, yell, np, wow, stay_down, got_one, cool, bigheads, wasted, kane, phew, superman, hero, oo, o.o, comeon, cmon, gun, ambulance, flies");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sound7ChatCommand> Sound7ChatCommandReg("!sound7",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sound8ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: woops, whoa, yeah2, ha, hey2, yes_sir2, yes_sir3, ow2, pin7, rape, ty, 1, 2, 3, 4, smart, yo, bird, time_to_die, elena, gogogo, orca_volley, whip, all_right, ceiling_turret");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sound8ChatCommand> Sound8ChatCommandReg("!sound8",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sounds1ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: chicky, skill, hehe, hh, tt, tuff, yes_sir, yeah, fall, got_it, grunt, good, dead, oops, creature, lol, roar, target, incinerate, fire, smell, ^^, toast, pain, present");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sounds1ChatCommand> Sounds1ChatCommandReg("!sounds1",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sounds2ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: burn, stupid, mechman, bell, inc, cow, creak, sak, monster, run2, what, clear, hurry, kill_him, jerks, gameover, gg, helidown, hmm, hey, heh, go, fight, cover_me");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sounds2ChatCommand> Sounds2ChatCommandReg("!sounds2",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sounds3ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: negattive, sorry, die, affirmative, bye, cya, aha, traffic, terrorist, shutup, stfu, destroy, no, whoops, ns, fun, unstable, guys, where, meee, target, attack, bla, junior");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sounds3ChatCommand> Sounds3ChatCommandReg("!sounds3",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sounds4ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: candy, boink, boink2, door, rain, destruction, yes, rav, father, tv, help, dont_shoot_me, hello, hi, hi2, haha, muhaha, hihi, move, medic, elephants, ow, aw, not_now");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sounds4ChatCommand> Sounds4ChatCommandReg("!sounds4",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sounds5ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: situation_under_control, time_for_action, support, gotcha, gotya, coffee, ask, hunt, boo, pray, amateur, eye, lucky, finally, mobius, system_backup, dubi, shatter, hit, bravo");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sounds5ChatCommand> Sounds5ChatCommandReg("!sounds5",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sounds6ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: bear, rooster, battle, dogs, petrova, pet, job_hazard, out_of_the_way, who_is_there, call_a_doctor, man_down, dance, headache, munchies, dont_shoot, quiet, heads_up");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sounds6ChatCommand> Sounds6ChatCommandReg("!sounds6",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sounds7ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: watch_out, help2, squirrel, run, yell, np, wow, stay_down, got_one, cool, bigheads, wasted, kane, phew, superman, hero, oo, o.o, comeon, cmon, gun, ambulance, flies");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sounds7ChatCommand> Sounds7ChatCommandReg("!sounds7",CHATTYPE_ALL,0,GAMEMODE_ALL);

class Sounds8ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		char msg1[256];
		sprintf(msg1, "msg [SSGM]: Core Patch 2 is required for listening current sounds. Type: !cp2 for download link.");
		Console_Input(msg1);
		char msg2[256];
		sprintf(msg2, "msg [SSGM]: woops, whoa, yeah2, ha, hey2, yes_sir2, yes_sir3, ow2, pin7, rape, ty, 1, 2, 3, 4, smart, yo, bird, time_to_die, elena, gogogo, orca_volley, whip, all_right, ceiling_turret");
		Console_Input(msg2);
	}
};
ChatCommandRegistrant<Sounds8ChatCommand> Sounds8ChatCommandReg("!sounds8",CHATTYPE_ALL,0,GAMEMODE_ALL);

